<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
* @filesource
*//** */


/**
* @package direct-as-a-service
* @subpackage models
*/
class AccountRequestModel extends CI_Model {
	
    function __construct() {
        parent::__construct();
		$this->load->database();
    }
    
    function create_request($first, $middle, $last, $ext_mail, $title, $department, $organization, $telephone, $mobile, $location, $facility_id, $user_org_id, $username = NULL)
    {
		return $this->db->query('INSERT INTO account_request (username,first_name,middle_name,last_name,ext_mail,title,department,organization,telephone,mobile,location,facility_id,user_org_id,request_date,denied) VALUES ('.$this->db->escape($username).','.$this->db->escape($first).','.$this->db->escape($middle).','.$this->db->escape($last).','.$this->db->escape($ext_mail).','.$this->db->escape($title).','.$this->db->escape($department).','.$this->db->escape($organization).','.$this->db->escape($telephone).','.$this->db->escape($mobile).','.$this->db->escape($location).','.$this->db->escape($facility_id).','.$this->db->escape($user_org_id).','.$this->db->escape(time()).',0)');
    }
	
	function approve_request($id) {
		return $this->db->query('UPDATE account_request SET approved_date='.$this->db->escape(time()).' WHERE id='.$this->db->escape($id));
    }
	
	function unapprove_request($id) {
		return $this->db->query('UPDATE account_request SET approved_date=NULL WHERE id='.$this->db->escape($id));
    }
	
	function deny_request($id,$justification) {
		return $this->db->query('UPDATE account_request SET justification='.$this->db->escape($justification).',denied = 1 WHERE id='.$this->db->escape($id));
    }
	
	function get_request($id)
    {
    	return $this->db->query('SELECT * FROM account_request WHERE id='.$this->db->escape($id));
    }
	
	function get_requests($type)
    {
    	if ($type == 'approved') {
    		return $this->db->query('SELECT * FROM account_request WHERE request_date IS NOT NULL AND approved_date IS NOT NULL AND denied = 0 ORDER BY approved_date DESC');
		}
    	else if ($type == 'denied') {
    		return $this->db->query('SELECT * FROM account_request WHERE request_date IS NOT NULL AND approved_date IS NULL AND denied = 1 ORDER BY request_date DESC');
		}
    	else {
    		return $this->db->query('SELECT * FROM account_request WHERE request_date IS NOT NULL AND approved_date IS NULL AND (denied IS NULL OR denied = 0) ORDER BY request_date DESC');
		}
    }
	
    public function get_requests_by_page_number($type, $start, $size, $search_input = null){
    	
    	if ($type == 'approved') {
    		$sql = 'SELECT * FROM (select *, ROW_NUMBER() over (order by approved_date DESC, first_name) as row FROM account_request ' .
    			'WHERE request_date IS NOT NULL AND approved_date IS NOT NULL AND denied = 0';
    		if($search_input != null && $search_input != '') {
    			$search_input_array = explode(' ', $search_input);
    			foreach($search_input_array as $input) {
    				$sql .= ' AND (';
    				$sql .= 'user_org_id like \'%' . $input . '%\' OR ' .
		    				'first_name like \'%' . $input . '%\' OR ' .
		    				'middle_name like \'%' . $input . '%\' OR ' .
		    				'last_name like \'%' . $input . '%\' OR ' .
		    				'title like \'%' . $input . '%\' OR ' .
		    				'department like \'%' . $input . '%\' OR ' .
		    				'organization like \'%' . $input . '%\' OR ' .
		    				'ext_mail like \'%' . $input . '%\' OR ' .
		    				'telephone like \'%' . $input . '%\' OR ' .
		    				'mobile like \'%' . $input . '%\' OR ' .
		    				'location like \'%' . $input . '%\' OR ' . 
		    				'YEAR(dateadd(second,approved_date,\'1970-01-01\')) like \'%' . $input . '%\' OR ' .
		    				'datename(month,dateadd(second,approved_date,\'1970-01-01\')) like \'%' . $input . '%\' OR ' .
		    				'DAY(dateadd(second,approved_date,\'1970-01-01\')) like \'%' . $input . '%\' OR ' .
		    				'CONVERT(VARCHAR(8),dateadd(second,approved_date,\'1970-01-01\'),108) like \'%' . $input . '%\'' .
    						')';
    			}
    		}
    		$sql .= ') ' . 
    			' a WHERE row >= ' . $this->db->escape($start) . ' and row < ' . $this->db->escape($size+$start);
    		return $this->db->query($sql);
    	}
    	else if ($type == 'denied') {
    		return $this->db->query('SELECT * FROM (select *, ROW_NUMBER() over (order by request_date DESC, first_name) as row FROM account_request ' .
    			'WHERE request_date IS NOT NULL AND approved_date IS NULL AND denied = 1) ' . 
    			' a WHERE row >= ' . $this->db->escape($start) . ' and row < ' . $this->db->escape($size+$start));
    	}
    	else {
    		return $this->db->query('SELECT * FROM (select *, ROW_NUMBER() over (order by request_date DESC, first_name) as row FROM account_request ' . 
    			'where request_date IS NOT NULL AND approved_date IS NULL AND (denied IS NULL OR denied = 0)) ' . 
    			' a WHERE row >= ' . $this->db->escape($start) . ' and row < ' . $this->db->escape($size+$start));
    	}
    }
    
    public function get_size_of_approved_account_request_list($search_input = null){
    	$sql = 'SELECT COUNT(*) as count FROM account_request ' .
    			'WHERE request_date IS NOT NULL AND approved_date IS NOT NULL AND denied = 0 ';
    	if($search_input != null && $search_input != '') {
    	$search_input_array = explode(' ', $search_input);
    			foreach($search_input_array as $input) {
    				$sql .= ' AND (';
    				$sql .= 'user_org_id like \'%' . $input . '%\' OR ' .
		    				'first_name like \'%' . $input . '%\' OR ' .
		    				'middle_name like \'%' . $input . '%\' OR ' .
		    				'last_name like \'%' . $input . '%\' OR ' .
		    				'title like \'%' . $input . '%\' OR ' .
		    				'department like \'%' . $input . '%\' OR ' .
		    				'organization like \'%' . $input . '%\' OR ' .
		    				'ext_mail like \'%' . $input . '%\' OR ' .
		    				'telephone like \'%' . $input . '%\' OR ' .
		    				'mobile like \'%' . $input . '%\' OR ' .
		    				'location like \'%' . $input . '%\' OR ' . 
		    				'YEAR(dateadd(second,approved_date,\'1970-01-01\')) like \'%' . $input . '%\' OR ' .
		    				'datename(month,dateadd(second,approved_date,\'1970-01-01\')) like \'%' . $input . '%\' OR ' .
		    				'DAY(dateadd(second,approved_date,\'1970-01-01\')) like \'%' . $input . '%\' OR ' .
		    				'CONVERT(VARCHAR(8),dateadd(second,approved_date,\'1970-01-01\'),108) like \'%' . $input . '%\'' .
    						')';
    			}
    	}
    	return $this->db->query($sql);
    }
    
	function get_requests_size($type)
    {
    	if ($type == 'approved') {
    		return $this->db->query('SELECT COUNT(*) as count FROM account_request WHERE request_date IS NOT NULL AND approved_date IS NOT NULL AND denied = 0');
		}
    	else if ($type == 'denied') {
    		return $this->db->query('SELECT COUNT(*) as count FROM account_request WHERE request_date IS NOT NULL AND approved_date IS NULL AND denied = 1');
		}
    	else {
    		return $this->db->query('SELECT COUNT(*) as count FROM account_request WHERE request_date IS NOT NULL AND approved_date IS NULL AND (denied IS NULL OR denied = 0)');
		}
    }
    
	function request_status($org_id) {
		$query = $this->db->query('SELECT TOP(1) approved_date, denied FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' ORDER BY request_date DESC');
		if($query) {
			if($query->num_rows() > 0) {
				$row = $query->row_array(0);
				if($row['denied']) { return 'Denied'; }
				if($row['approved_date'] === null) { return 'Pending'; }
				else { return 'Approved'; }
			}
			else { return 'No Requests'; }
		}
		return FALSE;
	}
	
	function get_justification($org_id, $request_id = null) {
		if(isset($request_id)) {
			$query = $this->db->query('SELECT justification FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' AND id='.$this->db->escape($request_id));
		}
		else {
			$query = $this->db->query('SELECT TOP(1) justification FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' ORDER BY request_date DESC');
		}
		if($query) {
			if($query->num_rows() === 1) { 
				$row = $query->row_array();
				return $row['justification'];
			}
		}
		return FALSE;
	}
	
	function get_account_request_data($org_id, $request_id = null) {
		if(isset($request_id)) {
			$query = $this->db->query('SELECT * FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' AND id='.$this->db->escape($request_id));
		}
		else {
			$query = $this->db->query('SELECT TOP(1) * FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' ORDER BY request_date DESC');
		}
		if($query) {
			if($query->num_rows() === 1) {
				$row = $query->row_array();
				return $row;
			}
		}
		return FALSE;
	}
	
	function get_ext_mail($org_id, $request_id = null) {
		if(isset($request_id)) {
			$query = $this->db->query('SELECT ext_mail FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' AND id='.$this->db->escape($request_id));
		}
		else {
			$query = $this->db->query('SELECT TOP(1) ext_mail FROM account_request WHERE user_org_id='.$this->db->escape($org_id).' ORDER BY request_date DESC');
		}
		if($query) {
			if($query->num_rows() === 1) { 
				$row = $query->row_array();
				return $row['ext_mail'];
			}
		}
		return FALSE;
	}
	function get_ids($name){
		return  $this->db->query('SELECT id FROM account_request WHERE user_org_id like '.$this->db->escape($name));
	}
}
